/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: OCF file access card service sample.
 *
 */

package ocfbundle;

import java.util.Enumeration;

import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.SecurityDomain;
import opencard.opt.terminal.ISOCommandAPDU;

/**
 * MyFileAccessService class
 * This class implements FileAccessCardService.
 * Only read method is implemented.
 * 
 * MyFileAccessServiceクラス
 * FileAccessCardServiceを実装しています。
 * read(CardFilePath,int,int)メソッドのみ実装しています。
 */
public class MyFileAccessService extends CardService implements FileAccessCardService {
	
	/**
	 * Card commands.
	 * 
	 * カードコマンド。
	 */
	private final static byte CLA_CRYPTO      = (byte)0xC0;
    private final static byte INS_SELECTFILE  = (byte)0xA4;
    private final static byte INS_READBINARY  = (byte)0xB0;
    private final static byte INS_GETRESPONSE = (byte)0xC0;
    private final static byte BZ              = (byte)0x00;
	
    /**
	 * Status words.
	 * 
	 * ステータスワード。
	 */
	private final static byte SW1_OK          = (byte)0x90;
	private final static byte SW1_MOREDATA    = (byte)0x61;
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#getRoot()
	 */
	public CardFilePath getRoot() {return null;}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#exists(opencard.opt.iso.fs.CardFilePath)
	 */
	public boolean exists(CardFilePath arg0) throws CardServiceException, CardTerminalException {return false;}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#getFileInfo(opencard.opt.iso.fs.CardFilePath)
	 */
	public CardFileInfo getFileInfo(CardFilePath arg0) throws CardServiceException, CardTerminalException {return null;}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#read(opencard.opt.iso.fs.CardFilePath, int, int)
	 */
	public byte[] read(CardFilePath path, int offset, int length) throws CardServiceException, CardTerminalException {
		try {
			allocateCardChannel();

			ISOCommandAPDU req = null;
			ResponseAPDU res = null;
			
			/*
			 * select the file
			 * ファイル選択
			 */
			Enumeration enums=path.components();
	    	while(enums.hasMoreElements()){
	    		CardFileFileID id=(CardFileFileID)enums.nextElement();
	    		
	    		req = new ISOCommandAPDU(
	    				CLA_CRYPTO,
	    				INS_SELECTFILE,
	    				BZ,
	    				BZ,
	    				id.toByteArray());
	    		res = getCardChannel().sendCommandAPDU(req);
	    		
	    		if (res.sw1() == SW1_MOREDATA) {
	    			req = new ISOCommandAPDU(
	    					CLA_CRYPTO,
	    					INS_GETRESPONSE,
	    					BZ,
	    					BZ,
	    					(int)res.sw2());
	        		res = getCardChannel().sendCommandAPDU(req);
	    		}
	    		
	    		if (res.sw1() != SW1_OK) {
	    			throw new CardServiceException("Status word bytes is not successful : " + 
	    					Integer.toHexString(res.sw()));
	    		}
	    	}
			
			/*
			 * read the file
			 * ファイル読み取り
			 */
	    	byte p1 = (byte)(offset/0x100);
	    	byte p2 = (byte)(offset%0x100);
	    	req = new ISOCommandAPDU(
	    			CLA_CRYPTO,
	    			INS_READBINARY,
	    			p1,
	    			p2,
	    			length
	    			);
			res = getCardChannel().sendCommandAPDU(req);
			
			if (res.sw1() == SW1_MOREDATA) {
				req = new ISOCommandAPDU(
						CLA_CRYPTO,
						INS_GETRESPONSE,
						BZ,
						BZ,
						(int)res.sw2());
	    		res = getCardChannel().sendCommandAPDU(req);
			}
			
	    	if (res.sw1() != SW1_OK) {
	    		throw new CardServiceException("Status word bytes is not successful : " + 
	    				Integer.toHexString(res.sw()));
	    		}
	    	
	    	return res.data();
		
		} finally {
			releaseCardChannel();
		}
	}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#readRecord(opencard.opt.iso.fs.CardFilePath, int)
	 */
	public byte[] readRecord(CardFilePath arg0, int arg1) throws CardServiceException, CardTerminalException {return null;}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#readRecords(opencard.opt.iso.fs.CardFilePath, int)
	 */
	public byte[][] readRecords(CardFilePath arg0, int arg1) throws CardServiceException, CardTerminalException {return null;}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#write(opencard.opt.iso.fs.CardFilePath, int, byte[], int, int)
	 */
	public void write(CardFilePath arg0, int arg1, byte[] arg2, int arg3, int arg4) throws CardServiceException, CardTerminalException {}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#write(opencard.opt.iso.fs.CardFilePath, int, byte[])
	 */
	public void write(CardFilePath arg0, int arg1, byte[] arg2) throws CardServiceException, CardTerminalException {}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#writeRecord(opencard.opt.iso.fs.CardFilePath, int, byte[])
	 */
	public void writeRecord(CardFilePath arg0, int arg1, byte[] arg2) throws CardServiceException, CardTerminalException {}
	
	/* (non-Javadoc)
	 * @see opencard.opt.iso.fs.FileAccessCardService#appendRecord(opencard.opt.iso.fs.CardFilePath, byte[])
	 */
	public void appendRecord(CardFilePath arg0, byte[] arg1) throws CardServiceException, CardTerminalException {}
	
	/* (non-Javadoc)
	 * @see opencard.opt.security.SecureService#provideCredentials(opencard.opt.security.SecurityDomain, opencard.opt.security.CredentialBag)
	 */
	public void provideCredentials(SecurityDomain arg0, CredentialBag arg1) throws CardServiceException {}

}
